unit uMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;
type     PATTData=^TATTData;
  TATTData = packed record
    CurGPU: dword;
    CurMEM: dword;
    isGameActive: dword;
    is3DActive: dword;

    isMonSourcesSupported: dword;
    GPUTemp: dword;
    MEMTemp: dword;
    FanDuty: dword;

    MAXGpuTemp: dword;
    MINGpuTemp: dword;
    MAXEnvTemp: dword;
    MINEnvTemp: dword;
    // 3d settings
    CurD3DAA: dword;
    CurD3DAF: dword;
    CurOGLAA: dword;
    CurOGLAF: dword;
    // FPS
    IsActive: dword;
    CurFPS: dword;

    FreeVideo: dword;
    FreeTexture: dword;
    Cur3DApi: dword;
    MemUsed: dword;

    GPUTemp2: dword;
    MEMTemp2: dword;

  end;

type
  TfrmMain = class(TForm)
    Memo1: TMemo;
    Button1: TButton;
    Timer1: TTimer;
    procedure Button1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.dfm}

procedure TfrmMain.Button1Click(Sender: TObject);
begin
     Close;
end;

procedure TfrmMain.Timer1Timer(Sender: TObject);
var hMapObject:THandle;
    data:PATTData;
    s1,s2:string;
begin
	hMapObject := OpenFileMapping(FILE_MAP_ALL_ACCESS,TRUE,'ATITRAY_SMEM');
	if (hMapObject<>0)  then
        begin
		data := MapViewOfFile(hMapObject, FILE_MAP_WRITE, 0, 0, 0);
		if (data<>nil)  then
                begin
                     if (data.is3DActive=1) then s1:='3D' else s1:='2D';
                     if (data.isMonSourcesSupported=1) then s2:='Yes' else s2:='No';
			Memo1.Lines.Text:=Format('GPU Speed - %dMHz'^m+
				'MEM Speed - %dMHz'^m+
				'Current Mode - '+s1+^m+
				'Temperature Monitor Supported - '+s2+^m+
				'GPU1 Temperature - %d'^m+
				'MEM1 Temperature - %d'^m+
				'GPU2 Temperature - %d'^m+
				'MEM1 Temperature - %d'^m,
				[data.CurGPU, data.CurMEM,data.GPUTemp,data.MEMTemp,data.GPUTemp2,data.MEMTemp2]);
			UnmapViewOfFile(data);
			CloseHandle(hMapObject);

		end else  Memo1.Lines.Text:='Error getting ATI Tray Shared Memory Information';
	end else
        begin
		Memo1.Lines.Text:='ATI Tray Tools not found';
        end;

end;

end.
